
--SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--SET TRANSACTION ISOLATION LEVEL READ COMMITTED 
--SET TRANSACTION ISOLATION LEVEL REPEATABLE READ
--SET TRANSACTION ISOLATION LEVEL SERIALIZABLE


DECLARE 
  @total money, 
  @total2 money,
  @total2prev money,  
  @msg nvarchar(max),
  @count int

  
SET @total = (SELECT [Sum] FROM SavedSum) --   
print @total
print '--------------'

DECLARE 
  @now datetime,
  @loopCount int

SET @count = 0
SET @loopCount = 0

SET @now = GETDATE()

WHILE (DATEDIFF(second, @now, GETDATE()) <= 30) --   30 
BEGIN
  BEGIN TRAN  
  SET @loopCount = @loopCount + 1  
  
  SET @total2 = (SELECT SUM(Amount) FROM Accounts) --    
  
  IF (@count > 0 AND @total2 != @total2prev)
  BEGIN
    SET @msg = 'total sum is incorrect: ' + CAST(@total2prev as nvarchar(100)) + '(' + CAST(@count as nvarchar(10)) + ' times)'
    print @msg
    SET @count = 0
  END
  
  IF (@total2 != @total) --         (    2  3   )
  BEGIN    
    SET @count = @count + 1
  END
  
  
  SET @total2prev = @total2
  COMMIT TRAN
  
END

print ''
print '-------------------------'
print 'Queries run:'
print @loopCount  -- -          ,   ,   30 ,  
